/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.memory;

import dev.engine_room.flywheel.lib.memory.DebugMemoryBlockImpl;
import dev.engine_room.flywheel.lib.memory.MemoryBlockImpl;
import dev.engine_room.flywheel.lib.memory.TrackedMemoryBlockImpl;
import java.nio.ByteBuffer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface MemoryBlock {
    public long ptr();

    public long size();

    public boolean isFreed();

    public boolean isTracked();

    public void copyTo(MemoryBlock var1);

    public void copyTo(long var1, long var3);

    public void copyTo(long var1);

    public void clear();

    public ByteBuffer asBuffer();

    public MemoryBlock realloc(long var1);

    public void free();

    public static MemoryBlock malloc(long size) {
        if (MemoryBlockImpl.DEBUG_MEMORY_SAFETY) {
            return DebugMemoryBlockImpl.malloc(size);
        }
        return MemoryBlockImpl.malloc(size);
    }

    public static MemoryBlock mallocTracked(long size) {
        return TrackedMemoryBlockImpl.malloc(size);
    }

    public static MemoryBlock calloc(long num, long size) {
        if (MemoryBlockImpl.DEBUG_MEMORY_SAFETY) {
            return DebugMemoryBlockImpl.calloc(num, size);
        }
        return MemoryBlockImpl.calloc(num, size);
    }

    public static MemoryBlock callocTracked(long num, long size) {
        return TrackedMemoryBlockImpl.calloc(num, size);
    }
}

